/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
********************************************************************************
* File Name          : 71x_map.h
* Author             : MCD Application Team
* Date First Issued  : 16/05/2003
* Description        : Peripherals registers definition and memory mapping.
********************************************************************************
* History:
*  16/05/2003 : Created.
*******************************************************************************/
#ifndef _71x_map_H
#define _71x_map_H


typedef volatile unsigned long   u32;
typedef volatile unsigned short  u16;
typedef volatile unsigned char   u8;

/* IP registers structures */

/* General Purpose I/O */
typedef volatile struct
{
  u16 PC0;
  u16 EMPTY1;
  u16 PC1;
  u16 EMPTY2;
  u16 PC2;
  u16 EMPTY3;
  u16 PD;
} GPIO_TypeDef;

/* Enhanced Interrupt Controller */
typedef volatile struct
{
  u32 ICR;       // Interrupt Control Register
  u32 CICR;      // Current Interrupt Channel Register
  u32 CIPR;      // Current Interrupt Priority Register
  u32 EMPTY1[3];
  u32 IVR;       // Interrupt Vector Register
  u32 FIR;       // Fast Interrupt Register
  u32 IER;       // Interrupt Enable Register
  u32 EMPTY2[7];
  u32 IPR;      //  Interrupt Pending Register
  u32 EMPTY3[7];
  u32 SIR[32]  ; // Source Interrupt Registers - Channel n
} EIC_TypeDef;

/* Timer */
typedef volatile struct
{
  u16 ICAR;    // Input Capture A Register
  u16 EMPTY1;
  u16 ICBR;   // Input Capture B Register
  u16 EMPTY2;
  u16 OCAR;   // Output Compare A Register
  u16 EMPTY3;
  u16 OCBR;   // Input Capture B Register
  u16 EMPTY4;
  u16 CNTR;   // Counter Register
  u16 EMPTY5;
  u16 CR1;    // Control Register 1
  u16 EMPTY6;
  u16 CR2;    // Control Register 2
  u16 EMPTY7;
  u16 SR;     // Status Register
  u16 EMPTY8;
} TIM_TypeDef;

/* Memory mapping */

#define APB2_BASE	0xE0000000
#define EIC_BASE	0xFFFFF800

#define GPIO0_BASE	(APB2_BASE + 0x3000)
#define GPIO1_BASE	(APB2_BASE + 0x4000)
#define TIM0_BASE	(APB2_BASE + 0x9000)
#define TIM1_BASE	(APB2_BASE + 0xA000)

#define GPIO0       ((GPIO_TypeDef *)GPIO0_BASE)
#define GPIO1       ((GPIO_TypeDef *)GPIO1_BASE)
#define EIC         ((EIC_TypeDef  *)EIC_BASE)
#define TIM0        ((TIM_TypeDef  *)TIM0_BASE)
#define TIM1        ((TIM_TypeDef  *)TIM1_BASE)

#endif  /* _71x_map_H*/

/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
